
#include "integer_vector.h"

#include <math.h>

#define SMALL 0   //eigentlich 512/sizeof(number) oder 256/  ?

void integer_vector::check_dimensions(const integer_vector& vec) const
{ if (d!=vec.d)
   error_handler(1,"vector arguments have different dimensions.");
 }


integer_vector::integer_vector() 
{ d = 0; 
  v = nil;
 }


integer_vector::integer_vector(int n) 
{ 
 if (n<0) error_handler(1,"vector: negative dimension."); 
 d = n; 
 v = nil;
 if (d > 0)
 { if (d < SMALL)
       v = (number*)allocate_bytes(d*sizeof(number));
   else
       v = new number[d];

   number zero = 0;
   while (n--) v[n] = zero;
  }
}


integer_vector::~integer_vector() 
{ if (v) 
    if (d < SMALL) 
       deallocate_bytes(v,d*sizeof(number));
    else
       delete[] v;
}


integer_vector::integer_vector(const integer_vector& p) 
{ d = p.d; 
  v = nil;
  if (d > 0) 
  { if (d < SMALL)
        v = (number*)allocate_bytes(d*sizeof(number));
    else
        v = new number[d];
    for(int i=0; i<d; i++) v[i] = p.v[i];
   }
}



integer_vector::integer_vector(number x, number y) 
{ v = (number*)allocate_bytes(2*sizeof(number));
  d = 2;
  v[0] = x;
  v[1] = y;
 }

integer_vector::integer_vector(number x, number y, number z) 
{ v = (number*)allocate_bytes(3*sizeof(number));
  d = 3;
  v[0] = x;
  v[1] = y;
  v[2] = z;
 }

/* moved to h-file

number  integer_vector::operator[](int i) const
{ if (i<0 || i>=d)  error_handler(1,"vector: index out of range ");
  return v[i]; 
}

number& integer_vector::operator[](int i)
{ if (i<0 || i>=d)  error_handler(1,"vector: index out of range ");
  return v[i]; 
}

*/


integer_vector& integer_vector::operator+=(const integer_vector& vec)
{ check_dimensions(vec);
  register int n = d;
  while (n--) v[n] += vec.v[n];
  return *this;
}

integer_vector& integer_vector::operator-=(const integer_vector& vec)
{ check_dimensions(vec);
  register int n = d;
  while (n--) v[n] -= vec.v[n];
  return *this;
}

integer_vector integer_vector::operator+(const integer_vector& vec) const
{ check_dimensions(vec);
  register int n = d;
  integer_vector result(n);
  while (n--) result.v[n] = v[n]+vec.v[n];
  return result;
}

integer_vector integer_vector::operator-(const integer_vector& vec) const
{ check_dimensions(vec);
  register int n = d;
  integer_vector result(n);
  while (n--) result.v[n] = v[n]-vec.v[n];
  return result;
}

integer_vector integer_vector::operator-() const  // unary minus
{ register int n = d;
  integer_vector result(n);
  while (n--) result.v[n] = -v[n];
  return result;
}


integer_vector integer_vector::operator*(number x) const
{ int n = d;
  integer_vector result(n);
  while (n--) result.v[n] = v[n] * x;
  return result;
}

/*
integer_vector integer_vector::operator/(number x) const
{ int n = d;
  integer_vector result(n);
  while (n--) result.v[n] = v[n] / x;
  return result;
}
*/

//friend
integer_vector operator*(number f, const integer_vector& v) { return v*f;     } 

number integer_vector::operator*(const integer_vector& vec) const
{ check_dimensions(vec);
  number result=0;
  register int n = d;
  while (n--) result = result+v[n]*vec.v[n];
  return result;
}

integer_vector& integer_vector::operator=(const integer_vector& vec)
{ register int n = vec.d;

  if (n != d)
  { 
    if (v)
    { if (d < SMALL)
          deallocate_bytes(v,d*sizeof(number));
      else
          delete[] v;
     }

    if (n < SMALL)
        v = (number*)allocate_bytes(n*sizeof(number));
    else
        v = new number[n];

    d = n;
   }

  while (n--) v[n] = vec.v[n];

  return *this;
}


bool integer_vector::operator==(const integer_vector& vec)  const
{ if (vec.d != d) return false;
  int i = 0;
  while ((i<d) && (v[i]==vec.v[i])) i++;
  return (i==d) ? true : false;
 }


ostream& operator<<(ostream& s, const integer_vector& v)
{ for (int i=0;i<v.d;i++)  s << v[i] <<" ";
  return s;
}

istream& operator>>(istream& s, integer_vector& x)
{ int i=0;
  while (i<x.d && s >> x.v[i++]);
  return s;
}

//number integer_vector::length() const { return sqrt(*this * *this); }

/*
number integer_vector::angle(const integer_vector& y)  const
{ number l = length();
  number yl = y.length();

  if ( l==0 || yl==0)
    error_handler(1,"angle: zero argument\n");

  return  acos((*this)*y/(l*yl));  
}
*/



int integer_vector::cmp(const integer_vector& v1, const integer_vector& v2)
{ register int i;

  if (v1.dim() != v2.dim())
    error_handler(1,"compare(vector,vector): different dimensions\n");

  for(i=0; i < v1.dim() && v1[i]==v2[i]; i++);

  if (i == v1.dim()) return 0;
   
  return (v1[i] < v2[i]) ?  -1 : 1;
}

