#include <stdio.h>
#include <stdarg.h>
#include <string.h>

#include <db.h>

#include "globals.h"

/* like printf
 * but dependend on verbose level
 */
int dbgp(int level, const char *format, ...)
{
  va_list ap;
  int ret = 0;

  va_start(ap, format);
  if (verbose >= level)
    ret =  vfprintf(stderr, format, ap);
  va_end(ap);
  return ret;
}

/* iterates though all elements dbp
 * calls cbf(arg, dbp, key, value) for each element
 * close dbp
 */
int iterate_db(DB *dbp, int (*cbf)(), void *arg)
{
  int ret;
  DBC *cursorp;
  DBT key, value;

  dbp->cursor(dbp, NULL, &cursorp, 0);
  memset(&key, 0 ,sizeof(DBT));
  memset(&value, 0 ,sizeof(DBT));
  while ((ret = cursorp->c_get(cursorp, &key, &value, DB_NEXT)) == 0) {
    if ((ret = (*cbf)(arg, dbp, &key, &value)) != 0)
      goto out;
  }
  if (ret == DB_NOTFOUND)
    ret = 0;
out:
  cursorp->c_close(cursorp);
  dbp->close(dbp, 0);
  return ret;
}
